#ifndef FILE_H_INCLUDED
#define FILE_H_INCLUDED
#include "gmp.h"
// LIST OF PRECOMPUTED SYSTEM PARAMETERS

#define KAZ_DS_SP_J				256

#define KAZ_DS_SP_g1			"65537"
#define KAZ_DS_SP_g2			"65539"

#define KAZ_DS_SP_N				"29421818394147345935036136135391375994024126405325576672227398037"\
                                "49355945200811628359470906909788031911794634328135763144755604190"\
                                "38845862081616787105974697279997461798630453885591474074570682758"\
                                "15914914983896392757878683919189075898269550939868181179868469970"\
                                "964809582599153788719655"
#define KAZ_DS_SP_phiN			"50292424825163552562978587619437224014186391216845845274999569746"\
                                "74551600879325043421757103306329441428870805867163463459072148880"\
                                "07643703094458414828200990128223075181127530152432620200757034038"\
                                "48545816307161422683474180459684923036013856370458624000000000000"\
                                "00000000000000000000000"

#define KAZ_DS_SP_Og1N			"49577346943749914278558040936897577826073730777121114343013903022328490384000"
#define KAZ_DS_SP_Og2N			"24788673471874957139279020468448788913036865388560557171506951511164245192000"

#define KAZ_DS_VBYTES			118
#define KAZ_DS_SBYTES			32
#define KAZ_DS_TBYTES			32
#define KAZ_DS_S1BYTES			118
#define KAZ_DS_S2BYTES			118
#define KAZ_DS_S3BYTES			118

extern void init_random();
extern void clear_random();
extern void KAZ_SIGN_RANDOM(mpz_t lb, mpz_t ub, mpz_t out);

extern void KAZ_DS_KEYGEN(unsigned char *kaz_ds_verify_key,
                          unsigned char *kaz_ds_sign_key);

extern int KAZ_DS_SIGNATURE(unsigned char *signature,
                             unsigned long long *signlen,
                             const unsigned char *m,
                             unsigned long long mlen,
                             const unsigned char *kaz_ds_sign_key);

extern int KAZ_DS_VERIFICATION(unsigned char *m,
                               unsigned long long *mlen,
							   const unsigned char *sm,
                               unsigned long long smlen,
                               const unsigned char *kaz_ds_verify_key);

#endif // FILE_H_INCLUDED
